/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright © 2023 Intel Corporation */

#include <stdio.h>
#include <stdlib.h>

int main(int argc, const char ** argv) {
    if (argc != 3) {
        fprintf(stderr, "%s %i %s\n", "Got incorrect number of arguments, got ", argc - 1, ", but expected 2");
        exit(1);
    }

    FILE * input, * output;

    if ((input = fopen(argv[1], "rb")) == NULL) {
        exit(1);
    }
    if ((output = fopen(argv[2], "wb")) == NULL) {
        exit(1);
    }

    fprintf(output, "#pragma once\n");
    fprintf(output, "#define ");

    int bytes_copied = 0;
    int c;
    while((c = fgetc(input)) != EOF) {
        if(fputc(c, output) == EOF) {
            fprintf(stderr, "Writing to output file failed.\n");
            return 1;
        }
        if(++bytes_copied > 10000) {
            fprintf(stderr, "File copy stuck in an eternal loop!\n");
            return 1;
        }
    }
    fputc('\n', output);

    fclose(input);
    fclose(output);

    return 0;
}
